/*
* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:	GPL-2.0+
*/

#ifndef _FB_OTP_H_
#define _FB_OTP_H_

#define OTPNAME "otpnand"
#define MAX_PAGE_SZ 2048
#define MAX_OTP_PAGES 4 /* Minimum of GD5F1GQ4UEYIH(4 pages) and W25N01GVZEIG(10 pages) */
#define COCOA_MAGIC "#ringotp"
#define COCOA_VER_LEN 4
#define COCOA_DSN_LEN 16
#define COCOA_BOARD_ID_LEN 16
#define NOOTP "No OTP programed"

enum {
	ERR_METADATA_USE_DEFAULTS = 1,
	ERR_METADATA_READ_OK = 0,
	ERR_METADATA_GENERAL = -1,
	ERR_METADATA_READ_FAIL = -2,
	ERR_METADATA_NOT_PROGRAMMED = -3
};

int is_otp_region(char *cmd_parameter);
bool is_otp_programmed(void);
bool is_otp_locked(void);
int write_nand_otp(void *fastboot_buf_addr, u32 image_size);
int fb_otp_nand_lock(void);
int try_otp_read_dsn(char *dsn);
int try_otp_read_all(char *dsn, char *boardid);
int set_serialno(void);
int try_otp_read_version(uint32_t *version);

#endif
